/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.indexer.performance;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;

public class PerformanceLogger {
    static final Log defaultLogger = LogFactory.getLog(PerformanceLogger.class);
    private static PerformanceLogger self = new PerformanceLogger();
    private static Log perfLogger;
    private static boolean enabled;

    private PerformanceLogger() {
        enabled = Settings.getConfiguration().getBoolean("dataone.indexing.performance.logging.enabled", Boolean.FALSE);
        defaultLogger.warn((Object)("Setting up PerformanceLogger: set to enabled? " + enabled));
        perfLogger = LogFactory.getLog((String)"performanceStats");
        if (perfLogger == null) {
            defaultLogger.error((Object)"Unable to create Log for performanceStats appender!");
            enabled = false;
        }
    }

    public static PerformanceLogger getInstance() {
        return self;
    }

    public void log(String id, long milliseconds) {
        if (enabled) {
            this.log(id + ", " + milliseconds);
        }
    }

    public void log(String message) {
        if (enabled) {
            perfLogger.info((Object)message);
        }
    }

    public boolean isLogEnabled() {
        return enabled;
    }
}

