/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.solr.client.solrj.SolrServerException;
import org.dataone.cn.indexer.solrhttp.DummySolrDoc;
import org.dataone.cn.indexer.solrhttp.OutputStreamHttpEntity;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.UnsupportedType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTTPService {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String XML_CONTENT_TYPE = "text/xml";
    private static final String ARCHIVED_FIELD = "archived";
    private static final String ARCHIVED_SHOWING_VALUE = "-archived:*fake";
    static final String PARAM_START = "start";
    static final String PARAM_ROWS = "rows";
    static final String PARAM_INDENT = "indent";
    static final String VALUE_INDENT_ON = "on";
    static final String PARAM_QUERY = "q";
    static final String PARAM_RETURN = "fl";
    static final String VALUE_WILDCARD = "*";
    static final String WT = "wt";
    private static final String MAX_ROWS = "5000";
    private List<String> copyDestinationFields = null;
    private static Log log = LogFactory.getLog((String)HTTPService.class.getName());
    private static HttpClient httpClient;
    private String SOLR_SCHEMA_PATH = Settings.getConfiguration().getString("solr.schema.path");
    private List<String> validSolrFieldNames = new ArrayList<String>();

    public HTTPService() throws IOException, ParserConfigurationException, SAXException {
        this.loadSolrSchemaFields();
    }

    public void sendUpdate(String uri, SolrElementAdd data, String encoding) throws IOException, SolrServerException {
        this.sendUpdate(uri, data, encoding, XML_CONTENT_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdate(String uri, SolrElementAdd data, String encoding, String contentType) throws IOException, SolrServerException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", contentType);
            post.setEntity((HttpEntity)new OutputStreamHttpEntity(data, encoding));
            response = HTTPService.getHttpClient().execute((HttpUriRequest)post);
            HttpEntity responseEntity = response.getEntity();
            log.info((Object)"HTTPService.sendUpdate - after get the http response entity.");
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStreamResponse, (OutputStream)baosResponse);
                String error = new String(baosResponse.toByteArray());
                post.abort();
                throw new SolrServerException("unable to update solr, non 200 response code." + error);
            }
            post.abort();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamResponse);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStreamResponse);
    }

    private void sendPost(String uri, String data) throws IOException {
        this.sendPost(uri, data, CHAR_ENCODING, XML_CONTENT_TYPE);
    }

    private void sendPost(String uri, String data, String encoding, String contentType) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", contentType);
            ByteArrayEntity entity = new ByteArrayEntity(data.getBytes());
            entity.setContentEncoding(encoding);
            post.setEntity((HttpEntity)entity);
            response = HTTPService.getHttpClient().execute((HttpUriRequest)post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStreamResponse, (OutputStream)baosResponse);
                String error = new String(baosResponse.toByteArray());
                log.error((Object)error);
                post.abort();
                throw new IOException("unable to update solr, non 200 response code." + error);
            }
            post.abort();
        }
        catch (Exception ex) {
            try {
                throw new IOException(ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStreamResponse);
    }

    public void sendSolrDelete(String pid, String solrUpdateUri) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.write((String)"<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, (String)CHAR_ENCODING);
        String escapedId = StringEscapeUtils.escapeXml((String)pid);
        IOUtils.write((String)("<delete><id>" + escapedId + "</id></delete>"), (OutputStream)outputStream, (String)CHAR_ENCODING);
        this.sendPost(solrUpdateUri, outputStream.toString());
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public List<SolrDoc> getDocumentsById(String uir, List<String> ids) throws IOException, XPathExpressionException, EncoderException {
        List<SolrDoc> docs = this.getDocumentsByField(uir, ids, "id", false);
        return docs;
    }

    public SolrDoc getDocumentBySeriesId(String seriesId, String uir) throws MalformedURLException, UnsupportedType, NotFound, SolrServerException, ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        StringBuilder query = new StringBuilder();
        query.append("seriesId:" + HTTPService.escapeQueryChars(seriesId) + " AND -obsoletedBy:*");
        log.debug((Object)("HTTPService.getDocumentBeySeriesId - the uir is " + uir));
        log.debug((Object)("HTTPService.getDocumentBeySeriesId - the query is " + query.toString()));
        ArrayList<SolrDoc> list = new ArrayList<SolrDoc>();
        list.addAll(this.doRequest(uir, query, MAX_ROWS));
        SolrDoc doc = null;
        if (list != null && !list.isEmpty()) {
            doc = (SolrDoc)list.get(0);
        }
        return doc;
    }

    public SolrDoc getSolrDocumentById(String uir, String id) throws XPathExpressionException, IOException, EncoderException {
        int targetIndex = 0;
        SolrDoc doc = null;
        List<SolrDoc> list = this.getDocumentById(uir, id);
        if (list != null && !list.isEmpty()) {
            doc = list.get(targetIndex);
        }
        return doc;
    }

    public List<SolrDoc> getDocumentById(String uir, String id) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(id), "id", false);
    }

    public List<SolrDoc> getDocumentsByResourceMap(String uir, String resourceMapId) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(resourceMapId), "resourceMap", true);
    }

    public List<SolrDoc> getDocumentsByField(String uir, List<String> fieldValues, String queryField, boolean maxRows) throws IOException, XPathExpressionException, EncoderException {
        if (fieldValues == null || fieldValues.size() <= 0) {
            return null;
        }
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        int rows = 0;
        String rowString = "";
        StringBuilder sb = new StringBuilder();
        for (String id : fieldValues) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(queryField + ":").append(HTTPService.escapeQueryChars(id));
            ++rows;
            if (sb.length() <= 5000) continue;
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
            rows = 0;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
        }
        return docs;
    }

    private List<SolrDoc> doRequest(String uir, StringBuilder sb, String rows) throws IOException, ClientProtocolException, XPathExpressionException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_QUERY, sb.toString()));
        params.add(new BasicNameValuePair(PARAM_START, "0"));
        params.add(new BasicNameValuePair(PARAM_ROWS, rows));
        params.add(new BasicNameValuePair(PARAM_INDENT, VALUE_INDENT_ON));
        params.add(new BasicNameValuePair(PARAM_RETURN, VALUE_WILDCARD));
        params.add(new BasicNameValuePair(WT, "xml"));
        params.add(new BasicNameValuePair(ARCHIVED_FIELD, ARCHIVED_SHOWING_VALUE));
        String paramString = URLEncodedUtils.format(params, (String)CHAR_ENCODING);
        String requestURI = uir + "?" + paramString;
        log.debug((Object)("HTTPService.doRequest - REQUEST URI: " + requestURI));
        HttpGet commandGet = new HttpGet(requestURI);
        HttpResponse response = HTTPService.getHttpClient().execute((HttpUriRequest)commandGet);
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(content);
        }
        catch (SAXException e) {
            log.error((Object)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
        }
        commandGet.abort();
        List<SolrDoc> docs = this.parseResults(document);
        return docs;
    }

    public SolrDoc retrieveDocumentFromSolrServer(String id, String solrQueryUri) throws XPathExpressionException, IOException, EncoderException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List<SolrDoc> indexedDocuments = this.getDocumentsById(solrQueryUri, ids);
        if (indexedDocuments.size() > 0) {
            return indexedDocuments.get(0);
        }
        return null;
    }

    private List<SolrDoc> parseResults(Document document) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/response/result/doc", document, XPathConstants.NODESET);
        ArrayList<SolrDoc> docList = new ArrayList<SolrDoc>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element docElement = (Element)nodeList.item(i);
            docList.add(this.parseDoc(docElement));
        }
        return docList;
    }

    private SolrDoc parseDoc(Element docElement) {
        SolrDoc doc = new SolrDoc();
        doc.loadFromElement(docElement, this.validSolrFieldNames);
        return doc;
    }

    public void setSolrSchemaPath(String path) {
        this.SOLR_SCHEMA_PATH = path;
    }

    private void loadSolrSchemaFields() throws IOException, ParserConfigurationException, SAXException {
        if (this.SOLR_SCHEMA_PATH != null && this.validSolrFieldNames.isEmpty()) {
            Document doc = this.loadSolrSchemaDocument();
            NodeList nList = doc.getElementsByTagName("copyField");
            this.copyDestinationFields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String destinationField = node.getAttributes().getNamedItem("dest").getNodeValue();
                this.copyDestinationFields.add(destinationField);
            }
            nList = doc.getElementsByTagName("field");
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String fieldName = node.getAttributes().getNamedItem("name").getNodeValue();
                fields.add(fieldName);
            }
            fields.removeAll(this.copyDestinationFields);
            if (!fields.contains(DummySolrDoc.getIndicationFieldName())) {
                fields.add(DummySolrDoc.getIndicationFieldName());
            }
            this.validSolrFieldNames = fields;
        }
    }

    private Document loadSolrSchemaDocument() throws IOException, ParserConfigurationException, SAXException {
        Document doc = null;
        InputStream fis = null;
        if (this.SOLR_SCHEMA_PATH.startsWith("http://") || this.SOLR_SCHEMA_PATH.startsWith("https://")) {
            log.info((Object)("HTTPService.loadSolrSchemaDocument - will load the schema file from " + this.SOLR_SCHEMA_PATH + " by http client"));
            HttpGet commandGet = new HttpGet(this.SOLR_SCHEMA_PATH);
            try {
                HttpResponse response = HTTPService.getHttpClient().execute((HttpUriRequest)commandGet);
                HttpEntity entity = response.getEntity();
                fis = entity.getContent();
            }
            catch (IOException e) {
                log.error((Object)("HTTPService.loadSolrSchemaDocument - can't get the schema doc from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                throw e;
            }
        }
        log.info((Object)("HTTPService.loadSolrSchemaDocument - will load the schema file from " + this.SOLR_SCHEMA_PATH + " by http client"));
        File schemaFile = new File(this.SOLR_SCHEMA_PATH);
        if (schemaFile != null) {
            try {
                fis = new FileInputStream(schemaFile);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("HTTPService.loadSolrSchemaDocument - can't get the schema doc from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                throw e;
            }
        }
        if (fis != null) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
                doc = dBuilder.parse(fis);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("HTTPService.loadSolrSchemaDocument - can't parse the schema doc from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                throw e;
            }
            catch (SAXException e) {
                log.error((Object)("HTTPService.loadSolrSchemaDocument - can't parse the schema doc from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                throw e;
            }
            catch (IOException e) {
                log.error((Object)("HTTPService.loadSolrSchemaDocument - can't parse the schema doc from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                throw e;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("HTTPService.loadSolrSchemaDocument - can't close the input stream from " + this.SOLR_SCHEMA_PATH + " since " + e.getMessage()));
                }
            }
        }
        return doc;
    }

    public static HttpClient getHttpClient() {
        return httpClient;
    }

    public List<String> getSolrCopyFields() {
        return this.copyDestinationFields;
    }

    static {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }
}

