/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.util.List;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;

public class DummySolrDoc
extends SolrDoc {
    private static final String INDICATION_FIELD = "isPlaceHolder_b";
    private static final String INDICATION_VALUE = "true";

    public DummySolrDoc(String pid, SolrDoc docHoldsPermission) {
        if (pid == null || pid.isBlank()) {
            throw new IllegalArgumentException("The id used to generate a dummy solr doc can't be null or blank");
        }
        SolrElementField idField = new SolrElementField("id", pid);
        this.addField(idField);
        this.addField(new SolrElementField("_version_", "-1"));
        if (docHoldsPermission != null) {
            DummySolrDoc.copyFieldAllValue("readPermission", docHoldsPermission, this);
            DummySolrDoc.copyFieldAllValue("writePermission", docHoldsPermission, this);
            DummySolrDoc.copyFieldAllValue("changePermission", docHoldsPermission, this);
            DummySolrDoc.copyFieldAllValue("rightsHolder", docHoldsPermission, this);
        }
        this.addField(new SolrElementField(INDICATION_FIELD, INDICATION_VALUE));
        this.addField(new SolrElementField("archived", "false"));
    }

    public static String getIndicationFieldName() {
        return INDICATION_FIELD;
    }

    public static String getIndicationFieldValue() {
        return INDICATION_VALUE;
    }

    protected static void copyFieldAllValue(String fieldName, SolrDoc source, SolrDoc dest) {
        List<String> values;
        if (fieldName != null && !fieldName.isBlank() && (values = source.getAllFieldValues(fieldName)) != null && !values.isEmpty()) {
            for (String value : values) {
                dest.addField(new SolrElementField(fieldName, value));
            }
        }
    }
}

