/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.parser.utility.SpatialBoxParsingUtility;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;

public class DublinCoreSpatialBoxGeohashSolrField
extends SolrField
implements ISolrField {
    private static Log logger = LogFactory.getLog((String)DublinCoreSpatialBoxGeohashSolrField.class.getName());
    private static SpatialBoxParsingUtility boxParsingUtility = new SpatialBoxParsingUtility();

    public DublinCoreSpatialBoxGeohashSolrField() {
    }

    public DublinCoreSpatialBoxGeohashSolrField(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        return this.parseBox(doc);
    }

    private List<SolrElementField> parseBox(Document doc) {
        String westValue;
        String eastValue;
        String southValue;
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        String nodeValue = boxParsingUtility.extractNodeValue(doc, this.xPathExpression);
        String northValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "northlimit");
        Object latLongValue = northValue + " " + (southValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "southlimit")) + " " + (eastValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "eastlimit")) + " " + (westValue = boxParsingUtility.extractDublinCoreDirectionalValue(nodeValue, "westlimit"));
        if (latLongValue != null && StringUtils.isNotEmpty((CharSequence)latLongValue)) {
            latLongValue = ((String)latLongValue).trim();
            boxParsingUtility.addGeohashLevelField(1, "geohash_1", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(2, "geohash_2", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(3, "geohash_3", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(4, "geohash_4", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(5, "geohash_5", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(6, "geohash_6", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(7, "geohash_7", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(8, "geohash_8", (String)latLongValue, fields);
            boxParsingUtility.addGeohashLevelField(9, "geohash_9", (String)latLongValue, fields);
        }
        return fields;
    }
}

