/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object.legacystore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.indexer.object.ObjectManager;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class LegacyStoreObjManager
extends ObjectManager {
    private static final String DATA_ROOT_DIR_ENV_NAME = "DATAONE_INDEXER_METACAT_DATA_ROOT_DIR";
    private static final String DOCUMENT_ROOT_DIR_ENV_NAME = "DATAONE_INDEXER_METACAT_DOCUMENT_ROOT_DIR";
    private static final String DATA_ROOT_DIR_PROPERTY_NAME = "index.data.root.directory";
    private static final String DOCUMENT_ROOT_DIR_PROPERTY_NAME = "index.document.root.directory";
    private static String dataRootDir;
    private static String documentRootDir;
    private static Logger logger;
    private static boolean ifDataAndDocRootSame;

    public LegacyStoreObjManager() throws ServiceFailure {
        LegacyStoreObjManager.refreshD1Node();
        dataRootDir = System.getenv(DATA_ROOT_DIR_ENV_NAME);
        logger.debug((Object)("The data root dir from env DATAONE_INDEXER_METACAT_DATA_ROOT_DIR is " + dataRootDir));
        if (dataRootDir == null || dataRootDir.isBlank()) {
            dataRootDir = Settings.getConfiguration().getString(DATA_ROOT_DIR_PROPERTY_NAME);
            logger.debug((Object)("The data root dir from the properties is " + dataRootDir));
        }
        if (dataRootDir == null || dataRootDir.isBlank()) {
            throw new ServiceFailure("0000", "The data root directory specified by the env variable DATAONE_INDEXER_METACAT_DATA_ROOT_DIR or the property index.data.root.directory in the properties file is null/blank");
        }
        documentRootDir = System.getenv(DOCUMENT_ROOT_DIR_ENV_NAME);
        logger.debug((Object)("The document root dir from env DATAONE_INDEXER_METACAT_DOCUMENT_ROOT_DIR is " + documentRootDir));
        if (documentRootDir == null || documentRootDir.isBlank()) {
            documentRootDir = Settings.getConfiguration().getString(DOCUMENT_ROOT_DIR_PROPERTY_NAME);
            logger.debug((Object)("The document root dir from the properties is " + documentRootDir));
        }
        if (documentRootDir == null || documentRootDir.isBlank()) {
            throw new ServiceFailure("0000", "The document root directory specified by the env variable DATAONE_INDEXER_METACAT_DOCUMENT_ROOT_DIR or the property index.document.root.directory in the properties file is blank.");
        }
        if (!Files.exists(FileSystems.getDefault().getPath(dataRootDir, new String[0]), new LinkOption[0])) {
            throw new ServiceFailure("0000", "The data root directory " + dataRootDir + " specified in the env variable or the properties file doesn't exist");
        }
        if (!Files.exists(FileSystems.getDefault().getPath(documentRootDir, new String[0]), new LinkOption[0])) {
            throw new ServiceFailure("0000", "The document root directory " + documentRootDir + " specified in the env variable or the properties file doesn't exist");
        }
        if (!dataRootDir.endsWith("/")) {
            dataRootDir = dataRootDir + "/";
        }
        if (!documentRootDir.endsWith("/")) {
            documentRootDir = documentRootDir + "/";
        }
        if (documentRootDir.equals(dataRootDir)) {
            ifDataAndDocRootSame = true;
        }
        logger.info((Object)("The root document directory is " + documentRootDir + " and the root data directory is " + dataRootDir + " Are they same?" + ifDataAndDocRootSame));
    }

    @Override
    public InputStream getObject(String pid) throws IllegalArgumentException, IOException, NotFound {
        File object = new File(documentRootDir + pid);
        if (!object.exists()) {
            object = new File(dataRootDir + pid);
            if (object.exists()) {
                return new FileInputStream(object);
            }
            throw new FileNotFoundException("Neither " + documentRootDir + " nor " + dataRootDir + " have the docid " + pid);
        }
        return new FileInputStream(object);
    }

    private String getFilePath(String relativePath, String objectFormat) throws NotFound {
        String absolutePath = null;
        if (relativePath != null && !relativePath.isBlank()) {
            if (ifDataAndDocRootSame) {
                absolutePath = documentRootDir + relativePath;
            } else if (objectFormat != null && !objectFormat.isBlank()) {
                ObjectFormat format = ObjectFormatCache.getInstance().getFormat(objectFormat);
                absolutePath = format.getFormatType().equals("METADATA") ? documentRootDir + relativePath : dataRootDir + relativePath;
            }
        }
        logger.debug((Object)("The absolute file path for the relative file path " + relativePath + " is " + absolutePath));
        return absolutePath;
    }

    @Override
    public org.dataone.service.types.v1.SystemMetadata getSystemMetadata(String id) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        SystemMetadata sysmeta = null;
        long start = System.currentTimeMillis();
        try {
            for (int i = 0; i < 5; ++i) {
                try {
                    sysmeta = LegacyStoreObjManager.getSystemMetadataByAPI(id);
                    break;
                }
                catch (ServiceFailure ee) {
                    logger.warn((Object)("The DataONE api call doesn't get the system metadata since " + ee.getMessage() + ". This is " + i + " try and Indexer will try again."));
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ie) {
                        logger.info((Object)"The sleep of the thread was interrupted.");
                    }
                    continue;
                }
            }
            logger.debug((Object)("Finish getting the system metadata via the DataONE API call for the pid " + id));
        }
        catch (NotAuthorized e) {
            logger.info((Object)("Failed to get the system metadata via the DataONE API call for the pid " + id + " since it is not authorized. We will refresh the token and try again"));
            LegacyStoreObjManager.refreshD1Node();
            sysmeta = LegacyStoreObjManager.getSystemMetadataByAPI(id);
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Finish getting the system metadata via DataONE API for the pid " + id + " and it took " + (end - start) + "milliseconds"));
        return sysmeta;
    }

    @Override
    public InputStream getSystemMetadataStream(String id) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, IOException, MarshallingException {
        long start = System.currentTimeMillis();
        ByteArrayInputStream sysmetaInputStream = null;
        SystemMetadata sysmeta = (SystemMetadata)this.getSystemMetadata(id);
        logger.debug((Object)("Finish getting the system metadata via the DataONE API call for the pid " + id));
        if (sysmeta != null) {
            ByteArrayOutputStream systemMetadataOutputStream = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)systemMetadataOutputStream);
            sysmetaInputStream = new ByteArrayInputStream(systemMetadataOutputStream.toByteArray());
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Finish getting the system metadata via DataONE API for the pid " + id + " and it took " + (end - start) + "milliseconds"));
        return sysmetaInputStream;
    }

    protected String getDataRootDir() {
        return dataRootDir;
    }

    protected String getDocumentRootDir() {
        return documentRootDir;
    }

    static {
        logger = Logger.getLogger(LegacyStoreObjManager.class);
        ifDataAndDocRootSame = false;
    }
}

