/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.object.ObjectManager;

public class ObjectManagerFactory {
    private static final String OBJECT_MANAGER_CLASS_NAME_ENV_NAME = "DATAONE_INDEXER_OBJECT_MANAGER_CLASS_NAME";
    private static volatile ObjectManager manager = null;
    private static final String DEFAULT_ClASS_NAME = "org.dataone.cn.indexer.object.hashstore.HashStoreObjManager";
    private static Log logger = LogFactory.getLog(ObjectManagerFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectManager getObjectManager() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String classNameFromEnv = ObjectManagerFactory.getObjManagerClassNameFromEnv();
        String className = DEFAULT_ClASS_NAME;
        if (classNameFromEnv != null && !classNameFromEnv.isBlank()) {
            logger.debug((Object)("The ObjectManager class name form env variable DATAONE_INDEXER_OBJECT_MANAGER_CLASS_NAME is " + classNameFromEnv));
            className = classNameFromEnv;
        }
        if (manager != null) return manager;
        Class<ObjectManagerFactory> clazz = ObjectManagerFactory.class;
        synchronized (ObjectManagerFactory.class) {
            if (manager != null) return manager;
            logger.info((Object)("The final ObjectManager class name from env variable is " + classNameFromEnv));
            Class<?> managerClass = Class.forName(className);
            manager = (ObjectManager)managerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return manager;
        }
    }

    protected static String getObjManagerClassNameFromEnv() {
        return System.getenv(OBJECT_MANAGER_CLASS_NAME_ENV_NAME);
    }

    protected static void resetManagerNull() {
        manager = null;
    }
}

