/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.object;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.D1Node;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v2.impl.MultipartCNode;
import org.dataone.client.v2.impl.MultipartD1Node;
import org.dataone.client.v2.impl.MultipartMNode;
import org.dataone.cn.indexer.object.ObjectManagerFactory;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.SystemMetadata;

public abstract class ObjectManager {
    private static final String NODE_BASE_URL_ENV_NAME = "DATAONE_INDEXER_NODE_BASE_URL";
    private static final String TOKEN_ENV_NAME = "DATAONE_INDEXER_AUTH_TOKEN";
    protected static String nodeBaseURL;
    private static String dataONEauthToken;
    private static Log logger;
    private static final String TOKEN_FILE_PATH_PROP_NAME = "dataone.nodeToken.file";
    protected static MultipartD1Node d1Node;
    protected static Session session;

    public abstract InputStream getSystemMetadataStream(String var1) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, NoSuchAlgorithmException, IOException, MarshallingException;

    public abstract org.dataone.service.types.v1.SystemMetadata getSystemMetadata(String var1) throws InvalidToken, NotAuthorized, NoSuchAlgorithmException, NotImplemented, ServiceFailure, NotFound, InstantiationException, IllegalAccessException, IOException, MarshallingException;

    public abstract InputStream getObject(String var1) throws IllegalArgumentException, FileNotFoundException, NoSuchAlgorithmException, IOException, NotFound;

    public static void setD1Node(MultipartD1Node node) {
        d1Node = node;
    }

    public static void refreshD1Node() throws ServiceFailure {
        nodeBaseURL = System.getenv(NODE_BASE_URL_ENV_NAME);
        logger.debug((Object)("The node base url from env variable is " + nodeBaseURL));
        if (nodeBaseURL == null || nodeBaseURL.isBlank()) {
            nodeBaseURL = Settings.getConfiguration().getString("dataone.mn.baseURL");
            logger.debug((Object)("The node base url from the properties file is " + nodeBaseURL));
        }
        if ((dataONEauthToken = System.getenv(TOKEN_ENV_NAME)) == null || dataONEauthToken.isBlank()) {
            String tokenFilePath = Settings.getConfiguration().getString(TOKEN_FILE_PATH_PROP_NAME);
            if (tokenFilePath != null && !tokenFilePath.trim().equals("")) {
                logger.info((Object)("Can NOT get the token from the env variable so try to get the auth token from the file " + tokenFilePath));
                try {
                    dataONEauthToken = FileUtils.readFileToString((File)new File(tokenFilePath), (String)"UTF-8");
                }
                catch (IOException e) {
                    dataONEauthToken = null;
                    logger.warn((Object)("Can NOT get the auth token from the file " + tokenFilePath + " since " + e.getMessage()));
                }
                if (dataONEauthToken != null && !dataONEauthToken.isBlank()) {
                    logger.info((Object)("Got the auth token from the file " + tokenFilePath));
                }
            }
        } else {
            logger.info((Object)"Got the auth token from an env. variable");
        }
        if (dataONEauthToken == null || dataONEauthToken.isBlank()) {
            String message = "Could NOT get an auth token from either an env. variable or the properties file.So it will act as the public user.";
            String className = ObjectManagerFactory.getObjManagerClassNameFromEnv();
            if (className != null && className.equals("org.dataone.cn.indexer.object.legacystore.LegacyStoreObjManager")) {
                logger.error((Object)message);
            } else {
                logger.warn((Object)message);
            }
        }
        session = ObjectManager.createSession(dataONEauthToken);
        logger.info((Object)("Going to create the d1node with url " + nodeBaseURL));
        try {
            d1Node = ObjectManager.getMultipartD1Node(session, nodeBaseURL);
        }
        catch (IOException | ClientSideException e) {
            logger.error((Object)("Couldn't create the d1node for the url " + nodeBaseURL + " since " + e.getMessage()));
            throw new ServiceFailure("0000", e.getMessage());
        }
    }

    private static Session createSession(String authToken) {
        Session session = null;
        if (authToken == null || authToken.trim().equals("")) {
            logger.info((Object)"ObjectManager.createSession - Creating the public session");
            session = new Session();
        } else {
            logger.info((Object)("Creating authentication session from token: " + authToken.substring(0, 5) + "..."));
            session = new AuthTokenSession(authToken);
        }
        return session;
    }

    protected static String getDataONEauthToken() {
        return dataONEauthToken;
    }

    protected static D1Node getD1Node() {
        return d1Node;
    }

    private static MultipartD1Node getMultipartD1Node(Session session, String serviceUrl) throws IOException, ClientSideException {
        HttpMultipartRestClient mrc = null;
        MultipartCNode d1Node = null;
        mrc = new HttpMultipartRestClient();
        Boolean isCN = ObjectManager.isCN(serviceUrl);
        if (isCN.booleanValue()) {
            logger.info((Object)("Creating cn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartCNode((MultipartRestClient)mrc, serviceUrl, session);
        } else {
            logger.info((Object)("Creating mn MultipartMNode from the url " + serviceUrl));
            d1Node = new MultipartMNode((MultipartRestClient)mrc, serviceUrl, session);
        }
        return d1Node;
    }

    protected static Boolean isCN(String nodeStr) {
        Boolean isCN = false;
        if (nodeStr.matches("^\\s*urn:node:.*")) {
            if (nodeStr.matches("^\\s*urn:node:CN.*$|^\\s*urn:node:cn.*$")) {
                isCN = true;
                logger.debug((Object)("ObjectManager.isCN - The nodeId is for a CN: " + nodeStr));
            } else {
                logger.debug((Object)("ObjectManager.isCN - The nodeId is not for a CN: " + nodeStr));
                isCN = false;
            }
        } else if (nodeStr.matches("^\\s*https*://cn.*?\\.dataone\\.org.*$|https*://cn.*?\\.test\\.dataone\\.org.*$")) {
            isCN = true;
            logger.debug((Object)("ObjectManager.isCN - The service URL is for a CN: " + nodeStr));
        } else {
            logger.debug((Object)("ObjectManager.isCN - The service URL is not for a CN: " + nodeStr));
            isCN = false;
        }
        return isCN;
    }

    protected static SystemMetadata getSystemMetadataByAPI(String id) throws ServiceFailure, InvalidToken, NotImplemented, NotAuthorized, NotFound {
        if (d1Node != null) {
            Identifier identifier = new Identifier();
            identifier.setValue(id);
            return d1Node.getSystemMetadata(session, identifier);
        }
        throw new ServiceFailure("0000", "The d1Node is null and Indexer cannot get the systemmetadata by a API call.");
    }

    static {
        dataONEauthToken = null;
        logger = LogFactory.getLog(ObjectManager.class);
        d1Node = null;
        session = null;
    }
}

