/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.dataone.cn.indexer.convert.IConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SolrDateConverter
implements IConverter {
    private static TimeZone OUTPUT_TIMEZONE = TimeZone.getTimeZone("Zulu");
    protected static final String OUTPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected boolean assumeDate = false;

    @Override
    public String convert(String data) {
        if (data == null || ((String)data).equals("")) {
            return "";
        }
        if (this.assumeDate && !((String)data).contains("-")) {
            if (((String)data).length() == 6) {
                data = ((String)data).substring(0, 4) + "-" + ((String)data).substring(4);
            }
            if (((String)data).length() == 8) {
                data = ((String)data).substring(0, 4) + "-" + ((String)data).substring(4, 6) + "-" + ((String)data).substring(6);
            }
        }
        String outputDateFormat = "";
        try {
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)OUTPUT_TIMEZONE));
            DateTime dateTime = DateTime.parse((String)data);
            DateTime utcTime = dateTime.withZone(DateTimeZone.forTimeZone((TimeZone)OUTPUT_TIMEZONE));
            DateTimeFormatter sdf = DateTimeFormat.forPattern((String)OUTPUT_DATE_FORMAT);
            outputDateFormat = sdf.print((ReadableInstant)utcTime);
        }
        catch (Exception iae) {
            iae.printStackTrace();
        }
        return outputDateFormat;
    }

    public boolean isAssumeDate() {
        return this.assumeDate;
    }

    public void setAssumeDate(boolean assumeDate) {
        this.assumeDate = assumeDate;
    }

    public static Date ParseSolrDate(String date) {
        Date outputDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
            outputDate = sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return outputDate;
    }
}

