/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.parser.ISolrDataField;

public class OntologyModelService {
    private static Log log = LogFactory.getLog(OntologyModelService.class);
    private static String jarPrefix = "jar:file:";
    private static String jarAppendix = "!/";
    private static String filePrefix = "file:src/main/resources/";
    private static OntologyModelService instance = null;
    private static OntModel ontModel = null;
    public static final String FIELD_ANNOTATION = "sem_annotation";
    private static List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();
    private static List<String> ontologyList = new ArrayList<String>();
    private static Map<String, String> altEntryList = new HashMap<String, String>();

    private OntologyModelService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static OntologyModelService getInstance() {
        if (instance == null) {
            Class<OntologyModelService> clazz = OntologyModelService.class;
            // MONITORENTER : org.dataone.cn.indexer.annotation.OntologyModelService.class
            if (instance == null) {
                instance = new OntologyModelService();
                instance.init();
            }
            // MONITOREXIT : clazz
        }
        log.info((Object)("OntologyModelService.getInstance - the instance is " + instance.toString()));
        return instance;
    }

    private void init() {
        log.info((Object)(OntologyModelService.class.getName() + " init() called"));
        if (ontModel != null) {
            return;
        }
        ontModel = ModelFactory.createOntologyModel();
        this.loadAltEntries();
        for (String ontologyUri : ontologyList) {
            try {
                log.debug((Object)("Loading ontology " + ontologyUri));
                ontModel.read(ontologyUri);
            }
            catch (Exception e) {
                log.debug((Object)("Failed to read " + ontologyUri));
                e.printStackTrace();
            }
        }
    }

    protected Map<String, Set<String>> expandConcepts(String uri) {
        long start_method = System.currentTimeMillis();
        log.debug((Object)("expandConcepts " + uri));
        HashMap<String, Set<String>> conceptFields = new HashMap<String, Set<String>>();
        if (uri == null || uri.length() < 1) {
            log.debug((Object)("Expansion failed because uri " + uri + " was either null or non-zero length."));
            return conceptFields;
        }
        log.debug((Object)("About to run through fieldList which is size " + fieldList.size()));
        try {
            for (ISolrDataField field : fieldList) {
                String q = null;
                if (!(field instanceof SparqlField)) continue;
                q = ((SparqlField)field).getQuery();
                q = q.replaceAll("\\$CONCEPT_URI", uri);
                log.debug((Object)("SPARQL Query" + q.toString()));
                Query query = QueryFactory.create((String)q);
                QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)ontModel);
                ResultSet results = qexec.execSelect();
                String name = field.getName();
                HashSet<String> values = new HashSet<String>();
                long start = System.currentTimeMillis();
                while (results.hasNext()) {
                    QuerySolution solution = results.next();
                    log.debug((Object)("Solution SPARQL result: " + solution.toString()));
                    long end = System.currentTimeMillis();
                    log.info((Object)("OntologyMondelService.expandConcepts - the time to execute results.hasNext() " + (end - start) + "milliseconds."));
                    if (!solution.contains(name) || solution.get(field.getName()).isAnon()) continue;
                    String value = solution.get(name).toString();
                    log.debug((Object)("Adding value " + value));
                    values.add(value);
                    start = System.currentTimeMillis();
                }
                conceptFields.put(name, values);
            }
        }
        catch (QueryException ex) {
            log.error((Object)("OntologyModelService.expandConcepts(" + uri + ") encountered an exception while querying."));
        }
        long end = System.currentTimeMillis();
        log.info((Object)("OntologyModelService.expandConcept - the total time for the method is " + (end - start_method) + " milliseconds."));
        return conceptFields;
    }

    public List<ISolrDataField> getFieldList() {
        return fieldList;
    }

    public void setFieldList(List<ISolrDataField> flds) {
        fieldList = flds;
    }

    private List<String> getOntologyList() {
        return ontologyList;
    }

    public void setOntologyList(List<String> ontlist) {
        ontologyList = ontlist;
    }

    public Map<String, String> getAltEntryList() {
        return altEntryList;
    }

    public void setAltEntryList(Map<String, String> entryList) {
        altEntryList = entryList;
    }

    protected void loadAltEntries() {
        log.debug((Object)("OntologyModelService - Loading altEntries of size " + altEntryList.size()));
        OntDocumentManager ontManager = ontModel.getDocumentManager();
        ontManager.setProcessImports(false);
        boolean firstEntry = true;
        Object prefix = null;
        for (Map.Entry<String, String> entry : altEntryList.entrySet()) {
            String path = entry.getValue();
            if (firstEntry) {
                firstEntry = false;
                String jarFilePath = this.getJarFilePath();
                prefix = jarFilePath != null && !jarFilePath.trim().equals("") ? jarPrefix + jarFilePath + jarAppendix : filePrefix;
                log.info((Object)("OntologyModelService.loadAltEntries - the final prefix for ontology files is " + (String)prefix));
            }
            ontManager.addAltEntry(entry.getKey(), prefix + path);
        }
    }

    protected String getJarFilePath() {
        String jarPath = "";
        URL classResource = OntologyModelService.class.getResource(OntologyModelService.class.getSimpleName() + ".class");
        if (classResource == null) {
            return jarPath;
        }
        String url = classResource.toString();
        log.info((Object)("OntologyModelService.getJarFilePrefix - the full path of the class is " + url));
        if (url.startsWith(jarPrefix)) {
            String path = url.replaceAll("^jar:(file:.*[.]jar)!/.*", "$1");
            try {
                jarPath = Paths.get(new URL(path).toURI()).toString();
            }
            catch (MalformedURLException | URISyntaxException e) {
                jarPath = "";
            }
        }
        log.info((Object)("OntologyModelService.getJarFilePrefix - the full path of the jar file is " + jarPath));
        return jarPath;
    }
}

