/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.xml;

import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PublishIdentifierCommand
extends edu.ucsb.nceas.osti_elink.PublishIdentifierCommand {
    private static final Log log = LogFactory.getLog(PublishIdentifierCommand.class);
    private static DocumentBuilder dBuilder;

    @Override
    public boolean parse(String xml) throws OSTIElinkException {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        try {
            Document doc = dBuilder.parse(is);
            Element rootElement = doc.getDocumentElement();
            if (!rootElement.getNodeName().equals("records")) {
                return false;
            }
            NodeList childNodes = rootElement.getChildNodes();
            int numberOfRecord = 0;
            int numberOfOsitId = 0;
            int numberOfUrl = 0;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    if (!childElement.getNodeName().equals("record")) {
                        log.debug((Object)("It has a child whose name is " + childElement.getNodeName() + "rather than record"));
                        return false;
                    }
                    ++numberOfRecord;
                    NodeList grandChildNodes = childElement.getChildNodes();
                    for (int j = 0; j < grandChildNodes.getLength(); ++j) {
                        Node grandChildNode = grandChildNodes.item(j);
                        if (grandChildNode.getNodeType() == 1) {
                            if (grandChildNode.getNodeName().equals("osti_id")) {
                                ++numberOfOsitId;
                                NodeList ostiChildNodes = grandChildNode.getChildNodes();
                                for (int m = 0; m < ostiChildNodes.getLength(); ++m) {
                                    Node ostiChildNode = ostiChildNodes.item(m);
                                    if (ostiChildNode.getNodeType() != 3) {
                                        log.debug((Object)"The ostid_id element has other child nodes rather the text node");
                                        return false;
                                    }
                                    this.ostiId = ostiChildNode.getTextContent();
                                    log.debug((Object)("Set ostId " + this.ostiId));
                                }
                            } else if (grandChildNode.getNodeName().equals("site_url")) {
                                ++numberOfUrl;
                                NodeList urlChildNodes = grandChildNode.getChildNodes();
                                for (int n = 0; n < urlChildNodes.getLength(); ++n) {
                                    Node urlChildNode = urlChildNodes.item(n);
                                    if (urlChildNode.getNodeType() != 3) {
                                        log.debug((Object)"The url element has other child nodes rather the text node");
                                        return false;
                                    }
                                    this.url = urlChildNode.getTextContent();
                                    log.debug((Object)("Set url " + this.url));
                                }
                            } else {
                                log.debug((Object)("It has a child whose name is " + grandChildNode.getNodeName() + "rather than osti_id or url"));
                                return false;
                            }
                        }
                        if (numberOfOsitId > 1) {
                            log.debug((Object)("The number of osti_id is greater than 1 : " + numberOfOsitId));
                            return false;
                        }
                        if (numberOfUrl <= 1) continue;
                        log.debug((Object)("The number of url is greater than 1 : " + numberOfUrl));
                        return false;
                    }
                }
                if (numberOfRecord <= true) continue;
                log.debug((Object)("The number of record is greater than 1 : " + numberOfRecord));
                return false;
            }
            if (numberOfRecord != 1) {
                log.debug((Object)("The number of record does not equal 1 : " + numberOfRecord));
                return false;
            }
            if (numberOfOsitId != 1) {
                log.debug((Object)("The number of osti_id does not equal 1 : " + numberOfOsitId));
                return false;
            }
            if (numberOfUrl != 1) {
                log.debug((Object)("The number of url does not equal 1 : " + numberOfUrl));
                return false;
            }
        }
        catch (IOException | SAXException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        return true;
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

